#ifndef _SIMPLEXPROPERTY_DESC_H_
#define _SIMPLEXPROPERTY_DESC_H_

#include <buildspec.h>
// #include <GSTenums.h>
// #include <exceptions/GSTRuntimeException.h>
#include <Client/ClientUtils/Network/TableAttributeDesc.h>
#include <Geometry/SimplexProperty.h>

#include <boost/shared_ptr.hpp>
#include <string>

namespace GST
{
// exceptions:
// see below class!

namespace Geometry
{
class SimplexProperty;
}

namespace ClientUtils
{
class GST_API_EXPORT SimplexPropertyDesc : public TableAttributeDesc
{
	friend class boost::serialization::access;

public:
	SimplexPropertyDesc();

	SimplexPropertyDesc(const std::string &name,
						const std::string &tablename,
						DType type,
						int dimension,
						bool notNull,
						Geometry::PropertyAlignments alignment,
						const std::string &alternativeType = "",
						long id = -1);
	SimplexPropertyDesc(const TableAttributeDesc &parent,
						Geometry::PropertyAlignments alignment);
	SimplexPropertyDesc(const Geometry::SimplexProperty &geomProperty,
						const FeatureClassDesc &target,
						bool notNull = false,
						long id = -1);

	SimplexPropertyDesc(const SimplexPropertyDesc &other);
	~SimplexPropertyDesc()
	{
	}

	Geometry::PropertyAlignments getAlignment() const;
	void setAlignment(Geometry::PropertyAlignments val);
	virtual bool operator==(const SimplexPropertyDesc &other) const;
	virtual bool isConstrained() const;

protected:
	Geometry::PropertyAlignments alignment;

private:
	template<typename Archive>
	void serialize(Archive &ar, const unsigned int version)
	{
		// If you change members here do not forget to increment object version
		// (see bottom of this file)
		ar &boost::serialization::make_nvp(
			"TableAttributeDesc",
			boost::serialization::base_object<TableAttributeDesc>(*this));
		ar &boost::serialization::make_nvp("alignment", this->alignment);
		if(version >= 2)
		{
			ar &boost::serialization::make_nvp("id", this->id);
		}
	}
};
typedef boost::shared_ptr<SimplexPropertyDesc> SimplexPropertyDescPtr;
typedef std::map<std::string, SimplexPropertyDescPtr, Utils::UpperCaseCompare>
	SimplexPropertyDescList;
typedef boost::shared_ptr<SimplexPropertyDescList> SimplexPropertyDescListPtr;

typedef std::vector<SimplexPropertyDescPtr> SimplexPropertyList;
typedef boost::shared_ptr<SimplexPropertyList> SimplexPropertyDescArrayPtr;
using SimplexPropertyDescListBySubFeatureKind
	= std::map<std::string, SimplexPropertyDescListPtr>;
//-----------------------------------------------------------------------------------------------------------
} // namespace ClientUtils
} // namespace GST

BOOST_CLASS_EXPORT_KEY(GST::ClientUtils::SimplexPropertyDesc);

BOOST_CLASS_VERSION(GST::ClientUtils::SimplexPropertyDesc, 2)

#endif //_SIMPLEXPROPERTY_DESC_H_
